@echo off
REM PixyTrade DLL Build Script
REM Builds 32-bit DLL for TradeStation EasyLanguage

echo ========================================
echo PixyTrade DLL Build Script
echo ========================================

REM Check for Visual Studio
where cl >nul 2>&1
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Visual Studio C++ compiler not found.
    echo Please run this from a "Developer Command Prompt for VS"
    echo or "x86 Native Tools Command Prompt for VS"
    echo.
    echo You can find it in Start Menu under Visual Studio folder.
    echo.
    pause
    exit /b 1
)

REM Create build directory
if not exist build mkdir build
cd build

REM Configure with CMake (32-bit)
echo.
echo Configuring CMake (32-bit)...
cmake -G "Visual Studio 17 2022" -A Win32 ..
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo CMake configuration failed. Trying Visual Studio 2019...
    cmake -G "Visual Studio 16 2019" -A Win32 ..
    if %ERRORLEVEL% NEQ 0 (
        echo.
        echo ERROR: CMake configuration failed.
        cd ..
        pause
        exit /b 1
    )
)

REM Build Release configuration
echo.
echo Building Release...
cmake --build . --config Release
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Build failed.
    cd ..
    pause
    exit /b 1
)

echo.
echo ========================================
echo BUILD SUCCESSFUL!
echo ========================================
echo.
echo DLL location: %CD%\Release\PixyTrade.dll
echo.
echo Copy PixyTrade.dll to your TradeStation directory:
echo   C:\Program Files (x86)\TradeStation\Program
echo.
echo Or add the DLL location to your system PATH.
echo.

cd ..
pause
