# PixyTrade DLL for TradeStation

This DLL allows TradeStation EasyLanguage strategies to communicate with the PixyTrade Scanner to determine market conditions.

## Features

- **Real-time Updates**: Background polling every 5 seconds
- **Thread-safe**: Multiple symbols/sessions supported
- **Secure**: Uses HTTPS with Bearer token authentication
- **Lightweight**: No external dependencies (uses Windows native WinHTTP)

## Building

### Prerequisites

- Visual Studio 2019 or 2022 with C++ Desktop Development
- CMake 3.15 or higher

### Build Steps

1. Open **"x86 Native Tools Command Prompt for VS"** (32-bit required for TradeStation)
2. Navigate to this directory
3. Run `build.bat`
4. DLL will be in `build\Release\PixyTrade.dll`

## Installation

Copy `PixyTrade.dll` to:
```
C:\Program Files (x86)\TradeStation\Program
```

## Getting Your API Key

1. Go to https://pixytrade.com/scanner
2. Click on the **Strategy** tab
3. Click **Generate API Key**
4. Copy the key

## API Functions

### PT_Initialize(symbol, apiKey) → int
Initialize a session for a symbol.
- **symbol**: Stock symbol (e.g., "AAPL")
- **apiKey**: Your PixyTrade API key
- **Returns**: Session handle (>0) or 0 on error

### PT_GetArmed(handle) → int
Check if market conditions are favorable.
- **Returns**: 1=armed (trade), 0=not armed (don't trade), -1=error

### PT_GetRTHOnly(handle) → int
Check if trading is restricted to regular hours.
- **Returns**: 1=RTH only, 0=extended hours allowed, -1=error

### PT_Poll(handle) → int
Check if values have changed since last poll.
- **Returns**: 1=changed, 0=no change, -1=error

### PT_Cleanup(handle)
Release session resources. Call when done.

### PT_GetLastError() → string
Get the last error message for debugging.

## EasyLanguage Example

See `EasyLanguage_Example.txt` for a complete working example.

## Troubleshooting

### DLL not found
- Ensure DLL is in TradeStation's Program folder
- Restart TradeStation after copying

### API errors
- Check your API key is correct
- Use `PT_GetLastError()` to see error details
- Ensure you have an active PixyTrade subscription

### Build errors
- Use the **x86** (32-bit) command prompt, not x64
- TradeStation EasyLanguage requires 32-bit DLLs
